<?php
require_once '../includes/config.php';
require_once '../includes/Auth.php';

$auth = new Auth();
$error = '';
$success = '';

// Se já está autenticado, redirecionar
if ($auth->isAuthenticated()) {
    header('Location: index.php');
    exit;
}

// Processar registro
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $name = $_POST['name'] ?? '';
    $email = $_POST['email'] ?? '';
    $whatsapp = $_POST['whatsapp'] ?? '';
    $password = $_POST['password'] ?? '';
    $password_confirm = $_POST['password_confirm'] ?? '';

    // Validações
    if (empty($name) || empty($email) || empty($whatsapp) || empty($password)) {
        $error = 'Todos os campos são obrigatórios';
    } elseif ($password !== $password_confirm) {
        $error = 'As senhas não correspondem';
    } else {
        $result = $auth->register($name, $email, $whatsapp, $password);
        
        if ($result['success']) {
            header('Location: index.php');
            exit;
        } else {
            $error = $result['message'];
        }
    }
}
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Registro - Superflix</title>
    <link rel="stylesheet" href="../assets/css/style.css">
</head>
<body>
    <header>
        <div class="container">
            <nav class="navbar">
                <a href="index.php" class="logo">
                    <span style="color: #1db954;">●</span> SUPERFLIX
                </a>
            </nav>
        </div>
    </header>

    <section class="section" style="min-height: calc(100vh - 200px); display: flex; align-items: center;">
        <div class="container">
            <div style="max-width: 450px; margin: 0 auto; background-color: var(--bg-secondary); padding: 2rem; border-radius: 8px; border: 1px solid var(--border-color);">
                <h2 class="text-center mb-3">Criar Conta</h2>

                <?php if ($error): ?>
                    <div class="alert alert-danger">
                        <span>⚠️</span>
                        <span><?php echo htmlspecialchars($error); ?></span>
                    </div>
                <?php endif; ?>

                <form method="POST">
                    <div class="form-group">
                        <label for="name">Nome Completo</label>
                        <input type="text" id="name" name="name" required>
                    </div>

                    <div class="form-group">
                        <label for="email">Email</label>
                        <input type="email" id="email" name="email" required>
                    </div>

                    <div class="form-group">
                        <label for="whatsapp">WhatsApp</label>
                        <input type="tel" id="whatsapp" name="whatsapp" placeholder="(11) 99999-9999" required>
                        <small style="color: var(--text-secondary);">Mínimo 10 dígitos</small>
                    </div>

                    <div class="form-group">
                        <label for="password">Senha</label>
                        <input type="password" id="password" name="password" required>
                        <small style="color: var(--text-secondary);">Mínimo 6 caracteres</small>
                    </div>

                    <div class="form-group">
                        <label for="password_confirm">Confirmar Senha</label>
                        <input type="password" id="password_confirm" name="password_confirm" required>
                    </div>

                    <button type="submit" class="btn btn-primary btn-block">Criar Conta</button>
                </form>

                <hr style="border: none; border-top: 1px solid var(--border-color); margin: 1.5rem 0;">

                <p class="text-center">
                    Já tem conta? <a href="login.php" style="color: var(--primary); font-weight: 600;">Faça login aqui</a>
                </p>
            </div>
        </div>
    </section>

    <footer style="background-color: var(--bg-secondary); border-top: 1px solid var(--border-color); padding: 2rem 0; margin-top: 3rem;">
        <div class="container">
            <p class="text-center" style="color: var(--text-secondary);">© 2025 Superflix. Todos os direitos reservados.</p>
        </div>
    </footer>

    <script>
        // Formatar WhatsApp
        document.getElementById('whatsapp').addEventListener('input', function(e) {
            let value = e.target.value.replace(/\D/g, '');
            if (value.length > 0) {
                if (value.length <= 2) {
                    value = '(' + value;
                } else if (value.length <= 7) {
                    value = '(' + value.substring(0, 2) + ') ' + value.substring(2);
                } else {
                    value = '(' + value.substring(0, 2) + ') ' + value.substring(2, 7) + '-' + value.substring(7, 11);
                }
            }
            e.target.value = value;
        });
    </script>
</body>
</html>
