<?php
require_once '../includes/config.php';
require_once '../includes/Auth.php';

$auth = new Auth();

// Verificar autenticação
if (!$auth->isAuthenticated()) {
    header('Location: login.php');
    exit;
}

$current_user = $auth->getCurrentUser();
$error = '';
$success = '';

// Processar atualização de perfil
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $name = $_POST['name'] ?? '';
    $email = $_POST['email'] ?? '';
    $whatsapp = $_POST['whatsapp'] ?? '';

    if (empty($name) || empty($email) || empty($whatsapp)) {
        $error = 'Todos os campos são obrigatórios';
    } else {
        $result = $auth->updateProfile($name, $email, $whatsapp);
        if ($result['success']) {
            $success = $result['message'];
            $current_user = $auth->getCurrentUser();
        } else {
            $error = $result['message'];
        }
    }
}
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Meu Perfil - Superflix</title>
    <link rel="stylesheet" href="../assets/css/style.css">
</head>
<body class="authenticated">
    <!-- Header -->
    <header>
        <div class="container">
            <nav class="navbar">
                <a href="index.php" class="logo">
                    <span style="color: #1db954;">●</span> SUPERFLIX
                </a>
                
                <ul class="nav-links">
                    <li><a href="index.php">Início</a></li>
                    <li><a href="catalogo.php">Catálogo</a></li>
                </ul>

                <div class="nav-right">
                    <a href="logout.php" class="btn btn-danger btn-sm">Sair</a>
                </div>
            </nav>
        </div>
    </header>

    <!-- Perfil -->
    <section class="section">
        <div class="container">
            <div style="max-width: 600px; margin: 0 auto;">
                <h2 class="section-title text-center">Meu Perfil</h2>

                <?php if ($error): ?>
                    <div class="alert alert-danger">
                        <span>⚠️</span>
                        <span><?php echo htmlspecialchars($error); ?></span>
                    </div>
                <?php endif; ?>

                <?php if ($success): ?>
                    <div class="alert alert-success">
                        <span>✓</span>
                        <span><?php echo htmlspecialchars($success); ?></span>
                    </div>
                <?php endif; ?>

                <div style="background-color: var(--bg-secondary); padding: 2rem; border-radius: 8px; border: 1px solid var(--border-color); margin-bottom: 2rem; text-align: center;">
                    <img src="<?php echo $current_user['avatar']; ?>" alt="Avatar" style="width: 100px; height: 100px; border-radius: 50%; margin-bottom: 1rem;">
                    <h3><?php echo htmlspecialchars($current_user['name']); ?></h3>
                    <p style="color: var(--text-secondary);"><?php echo htmlspecialchars($current_user['email']); ?></p>
                </div>

                <form method="POST" style="background-color: var(--bg-secondary); padding: 2rem; border-radius: 8px; border: 1px solid var(--border-color);">
                    <div class="form-group">
                        <label for="name">Nome Completo</label>
                        <input type="text" id="name" name="name" value="<?php echo htmlspecialchars($current_user['name']); ?>" required>
                    </div>

                    <div class="form-group">
                        <label for="email">Email</label>
                        <input type="email" id="email" name="email" value="<?php echo htmlspecialchars($current_user['email']); ?>" required>
                    </div>

                    <div class="form-group">
                        <label for="whatsapp">WhatsApp</label>
                        <input type="tel" id="whatsapp" name="whatsapp" value="<?php echo htmlspecialchars($current_user['whatsapp']); ?>" required>
                    </div>

                    <div class="form-group">
                        <label>Membro desde</label>
                        <input type="text" value="<?php echo date('d/m/Y', strtotime($current_user['created_at'])); ?>" disabled style="background-color: var(--bg-tertiary); cursor: not-allowed;">
                    </div>

                    <button type="submit" class="btn btn-primary btn-block">Salvar Alterações</button>
                </form>

                <div style="margin-top: 2rem;">
                    <a href="minha-lista.php" class="btn btn-secondary btn-block">Minha Lista</a>
                </div>
            </div>
        </div>
    </section>

    <footer style="background-color: var(--bg-secondary); border-top: 1px solid var(--border-color); padding: 2rem 0; margin-top: 3rem;">
        <div class="container">
            <p class="text-center" style="color: var(--text-secondary);">© 2025 Superflix. Todos os direitos reservados.</p>
        </div>
    </footer>

    <script>
        // Formatar WhatsApp
        document.getElementById('whatsapp').addEventListener('input', function(e) {
            let value = e.target.value.replace(/\D/g, '');
            if (value.length > 0) {
                if (value.length <= 2) {
                    value = '(' + value;
                } else if (value.length <= 7) {
                    value = '(' + value.substring(0, 2) + ') ' + value.substring(2);
                } else {
                    value = '(' + value.substring(0, 2) + ') ' + value.substring(2, 7) + '-' + value.substring(7, 11);
                }
            }
            e.target.value = value;
        });
    </script>
</body>
</html>
