<?php
require_once '../includes/config.php';
require_once '../includes/Auth.php';
require_once '../includes/Favorites.php';

$auth = new Auth();
$favorites = new Favorites();

// Verificar autenticação
if (!$auth->isAuthenticated()) {
    header('Location: login.php');
    exit;
}

$current_user = $auth->getCurrentUser();
$user_favorites = $favorites->getAll($current_user['id']);
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Minha Lista - Superflix</title>
    <link rel="stylesheet" href="../assets/css/style.css">
</head>
<body class="authenticated">
    <!-- Header -->
    <header>
        <div class="container">
            <nav class="navbar">
                <a href="index.php" class="logo">
                    <span style="color: #1db954;">●</span> SUPERFLIX
                </a>
                
                <ul class="nav-links">
                    <li><a href="index.php">Início</a></li>
                    <li><a href="catalogo.php">Catálogo</a></li>
                    <li><a href="minha-lista.php" class="active">Minha Lista</a></li>
                </ul>

                <div class="nav-right">
                    <img src="<?php echo $current_user['avatar']; ?>" alt="Avatar" class="user-avatar">
                    <a href="logout.php" class="btn btn-danger btn-sm">Sair</a>
                </div>
            </nav>
        </div>
    </header>

    <!-- Minha Lista -->
    <section class="section">
        <div class="container">
            <h2 class="section-title">Minha Lista</h2>

            <?php if (!empty($user_favorites)): ?>
                <div class="content-grid">
                    <?php foreach ($user_favorites as $favorite): ?>
                        <div class="content-item">
                            <img src="<?php echo $favorite['poster_path']; ?>" alt="<?php echo htmlspecialchars($favorite['title']); ?>">
                            <div class="content-overlay">
                                <div class="content-title"><?php echo substr($favorite['title'], 0, 30); ?></div>
                                <div class="content-info">
                                    <span><?php echo ucfirst($favorite['type']); ?></span>
                                    <button class="btn btn-danger btn-sm" onclick="removeFavorite('<?php echo $favorite['id']; ?>')">✕</button>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
            <?php else: ?>
                <div style="text-align: center; padding: 3rem;">
                    <p style="font-size: 1.1rem; color: var(--text-secondary); margin-bottom: 1rem;">Sua lista está vazia</p>
                    <a href="catalogo.php" class="btn btn-primary">Explorar Catálogo</a>
                </div>
            <?php endif; ?>
        </div>
    </section>

    <footer style="background-color: var(--bg-secondary); border-top: 1px solid var(--border-color); padding: 2rem 0; margin-top: 3rem;">
        <div class="container">
            <p class="text-center" style="color: var(--text-secondary);">© 2025 Superflix. Todos os direitos reservados.</p>
        </div>
    </footer>

    <script src="../assets/js/app.js"></script>
    <script>
        function removeFavorite(contentId) {
            if (confirm('Remover dos favoritos?')) {
                Utils.ajax('api/favorites/remove.php', 'POST', { content_id: contentId })
                    .then(response => {
                        if (response.success) {
                            location.reload();
                        }
                    });
            }
        }
    </script>
</body>
</html>
