<?php
require_once '../includes/config.php';
require_once '../includes/Auth.php';

$auth = new Auth();
$error = '';
$success = '';

// Se já está autenticado, redirecionar
if ($auth->isAuthenticated()) {
    header('Location: index.php');
    exit;
}

// Processar login
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $email = $_POST['email'] ?? '';
    $password = $_POST['password'] ?? '';

    $result = $auth->login($email, $password);
    
    if ($result['success']) {
        header('Location: index.php');
        exit;
    } else {
        $error = $result['message'];
    }
}
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login - Superflix</title>
    <link rel="stylesheet" href="../assets/css/style.css">
</head>
<body>
    <header>
        <div class="container">
            <nav class="navbar">
                <a href="index.php" class="logo">
                    <span style="color: #1db954;">●</span> SUPERFLIX
                </a>
            </nav>
        </div>
    </header>

    <section class="section" style="min-height: calc(100vh - 200px); display: flex; align-items: center;">
        <div class="container">
            <div style="max-width: 400px; margin: 0 auto; background-color: var(--bg-secondary); padding: 2rem; border-radius: 8px; border: 1px solid var(--border-color);">
                <h2 class="text-center mb-3">Login</h2>

                <?php if ($error): ?>
                    <div class="alert alert-danger">
                        <span>⚠️</span>
                        <span><?php echo htmlspecialchars($error); ?></span>
                    </div>
                <?php endif; ?>

                <form method="POST">
                    <div class="form-group">
                        <label for="email">Email</label>
                        <input type="email" id="email" name="email" required>
                    </div>

                    <div class="form-group">
                        <label for="password">Senha</label>
                        <input type="password" id="password" name="password" required>
                    </div>

                    <button type="submit" class="btn btn-primary btn-block">Entrar</button>
                </form>

                <hr style="border: none; border-top: 1px solid var(--border-color); margin: 1.5rem 0;">

                <p class="text-center">
                    Não tem conta? <a href="registro.php" style="color: var(--primary); font-weight: 600;">Registre-se aqui</a>
                </p>
            </div>
        </div>
    </section>

    <footer style="background-color: var(--bg-secondary); border-top: 1px solid var(--border-color); padding: 2rem 0; margin-top: 3rem;">
        <div class="container">
            <p class="text-center" style="color: var(--text-secondary);">© 2025 Superflix. Todos os direitos reservados.</p>
        </div>
    </footer>
</body>
</html>
