<?php
require_once '../includes/config.php';
require_once '../includes/Auth.php';
require_once '../includes/SuperflixAPI.php';
require_once '../includes/Favorites.php';

$auth = new Auth();
$api = new SuperflixAPI();
$favorites = new Favorites();

// Obter filmes em destaque
$movies_response = $api->getMovies();
$movies = $movies_response['success'] ? array_slice($movies_response['data']['movies'] ?? [], 0, 20) : [];

// Obter séries em destaque
$series_response = $api->getSeries();
$series = $series_response['success'] ? array_slice($series_response['data']['series'] ?? [], 0, 20) : [];

$current_user = $auth->getCurrentUser();
$is_authenticated = $auth->isAuthenticated();
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Superflix - Assista Filmes, Séries e Animes</title>
    <link rel="stylesheet" href="../assets/css/style.css">
</head>
<body <?php echo $is_authenticated ? 'class="authenticated"' : ''; ?>>
    <!-- Header -->
    <header>
        <div class="container">
            <nav class="navbar">
                <a href="index.php" class="logo">
                    <span style="color: #1db954;">●</span> SUPERFLIX
                </a>
                
                <ul class="nav-links">
                    <li><a href="index.php" class="active">Início</a></li>
                    <li><a href="catalogo.php?type=movie">Filmes</a></li>
                    <li><a href="catalogo.php?type=series">Séries</a></li>
                    <li><a href="catalogo.php?type=anime">Animes</a></li>
                </ul>

                <div class="nav-right">
                    <form class="search-form" style="display: flex; gap: 0.5rem;">
                        <input type="text" class="search-box" placeholder="Pesquisar filmes e séries..." name="q">
                        <button type="submit" class="btn btn-primary btn-sm">Buscar</button>
                    </form>

                    <?php if ($is_authenticated): ?>
                        <div class="user-menu">
                            <a href="minha-lista.php" class="btn btn-secondary btn-sm">Minha Lista</a>
                            <img src="<?php echo $current_user['avatar']; ?>" alt="Avatar" class="user-avatar" title="<?php echo $current_user['name']; ?>">
                            <div style="position: relative;">
                                <button class="btn btn-secondary btn-sm" onclick="toggleUserMenu()" style="cursor: pointer;">Menu</button>
                                <div id="user-menu-dropdown" class="user-menu-dropdown" style="display: none; position: absolute; top: 100%; right: 0; background: var(--bg-secondary); border: 1px solid var(--border-color); border-radius: 5px; min-width: 200px; z-index: 100;">
                                    <a href="perfil.php" style="display: block; padding: 0.75rem 1rem; color: var(--text-primary); text-decoration: none; border-bottom: 1px solid var(--border-color);">Meu Perfil</a>
                                    <?php if ($auth->isAdmin()): ?>
                                        <a href="admin/dashboard.php" style="display: block; padding: 0.75rem 1rem; color: var(--primary); text-decoration: none; border-bottom: 1px solid var(--border-color);">Painel Admin</a>
                                    <?php endif; ?>
                                    <a href="logout.php" style="display: block; padding: 0.75rem 1rem; color: var(--danger); text-decoration: none;">Sair</a>
                                </div>
                            </div>
                        </div>
                    <?php else: ?>
                        <div class="user-menu">
                            <a href="login.php" class="btn btn-secondary btn-sm">Login</a>
                            <a href="registro.php" class="btn btn-primary btn-sm">Registrar</a>
                        </div>
                    <?php endif; ?>
                </div>
            </nav>
        </div>
    </header>

    <!-- Hero Section -->
    <section class="hero">
        <div class="container">
            <div class="hero-content">
                <h1>Bem-vindo à Superflix</h1>
                <p>Assista a filmes, séries e animes ilimitados em qualidade HD</p>
                <?php if (!$is_authenticated): ?>
                    <a href="registro.php" class="btn btn-primary btn-lg">Comece Agora</a>
                <?php endif; ?>
            </div>
        </div>
    </section>

    <!-- Filmes em Destaque -->
    <section class="section">
        <div class="container">
            <h2 class="section-title">Filmes em Destaque</h2>
            
            <?php if (!empty($movies)): ?>
                <div class="content-grid">
                    <?php foreach (array_slice($movies, 0, 8) as $movie): ?>
                        <div class="content-item">
                            <img src="<?php echo $movie['poster_path']; ?>" alt="<?php echo $movie['title']; ?>">
                            <div class="content-overlay">
                                <div class="content-title"><?php echo Utils::truncate($movie['title'], 30); ?></div>
                                <div class="content-info">
                                    <span>⭐ <?php echo round($movie['vote_average'], 1); ?>/10</span>
                                    <a href="detalhes.php?id=<?php echo $movie['id']; ?>&type=movie" class="btn btn-primary btn-sm">Ver</a>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
            <?php else: ?>
                <p class="text-center">Carregando filmes...</p>
            <?php endif; ?>
        </div>
    </section>

    <!-- Séries em Destaque -->
    <section class="section">
        <div class="container">
            <h2 class="section-title">Séries em Destaque</h2>
            
            <?php if (!empty($series)): ?>
                <div class="content-grid">
                    <?php foreach (array_slice($series, 0, 8) as $serie): ?>
                        <div class="content-item">
                            <img src="<?php echo $serie['poster_path']; ?>" alt="<?php echo $serie['title']; ?>">
                            <div class="content-overlay">
                                <div class="content-title"><?php echo Utils::truncate($serie['title'], 30); ?></div>
                                <div class="content-info">
                                    <span>⭐ <?php echo round($serie['vote_average'], 1); ?>/10</span>
                                    <a href="detalhes.php?id=<?php echo $serie['id']; ?>&type=series" class="btn btn-primary btn-sm">Ver</a>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
            <?php else: ?>
                <p class="text-center">Carregando séries...</p>
            <?php endif; ?>
        </div>
    </section>

    <!-- Footer -->
    <footer style="background-color: var(--bg-secondary); border-top: 1px solid var(--border-color); padding: 2rem 0; margin-top: 3rem;">
        <div class="container">
            <div class="row">
                <div class="col-3">
                    <h4 style="color: var(--primary);">Superflix</h4>
                    <p>A melhor plataforma de streaming de conteúdo.</p>
                </div>
                <div class="col-3">
                    <h5>Links Rápidos</h5>
                    <ul style="list-style: none;">
                        <li><a href="index.php">Início</a></li>
                        <li><a href="catalogo.php">Catálogo</a></li>
                        <li><a href="contato.php">Contato</a></li>
                    </ul>
                </div>
                <div class="col-3">
                    <h5>Suporte</h5>
                    <ul style="list-style: none;">
                        <li><a href="#">Ajuda</a></li>
                        <li><a href="#">Privacidade</a></li>
                        <li><a href="#">Termos</a></li>
                    </ul>
                </div>
                <div class="col-3">
                    <h5>Redes Sociais</h5>
                    <ul style="list-style: none;">
                        <li><a href="#">Facebook</a></li>
                        <li><a href="#">Twitter</a></li>
                        <li><a href="#">Instagram</a></li>
                    </ul>
                </div>
            </div>
            <hr style="border: none; border-top: 1px solid var(--border-color); margin: 2rem 0;">
            <p class="text-center" style="color: var(--text-secondary);">© 2025 Superflix. Todos os direitos reservados.</p>
        </div>
    </footer>

    <script src="../assets/js/app.js"></script>
    <script>
        function toggleUserMenu() {
            const menu = document.getElementById('user-menu-dropdown');
            menu.style.display = menu.style.display === 'none' ? 'block' : 'none';
        }

        document.addEventListener('click', function(e) {
            const menu = document.getElementById('user-menu-dropdown');
            if (menu && !e.target.closest('.user-menu')) {
                menu.style.display = 'none';
            }
        });
    </script>
</body>
</html>

<?php
// Classe Utils para uso em templates
class Utils {
    public static function truncate($text, $length = 100) {
        if (strlen($text) > $length) {
            return substr($text, 0, $length) . '...';
        }
        return $text;
    }
}
?>
