<?php
require_once '../../includes/config.php';
require_once '../../includes/Auth.php';
require_once '../../includes/Favorites.php';

header('Content-Type: application/json');

$auth = new Auth();
$favorites = new Favorites();

// Verificar autenticação
if (!$auth->isAuthenticated()) {
    echo json_encode(['success' => false, 'message' => 'Não autenticado']);
    exit;
}

$current_user = $auth->getCurrentUser();
$data = json_decode(file_get_contents('php://input'), true);

if (!isset($data['content_id'])) {
    echo json_encode(['success' => false, 'message' => 'ID do conteúdo não fornecido']);
    exit;
}

$result = $favorites->remove($current_user['id'], $data['content_id']);
echo json_encode($result);
?>
