<?php
require_once '../../includes/config.php';
require_once '../../includes/Auth.php';
require_once '../../includes/Favorites.php';

header('Content-Type: application/json');

$auth = new Auth();
$favorites = new Favorites();

$id = $_GET['id'] ?? null;

if (!$id) {
    echo json_encode(['is_favorite' => false]);
    exit;
}

if (!$auth->isAuthenticated()) {
    echo json_encode(['is_favorite' => false]);
    exit;
}

$current_user = $auth->getCurrentUser();
$is_favorite = $favorites->isFavorite($current_user['id'], $id);

echo json_encode(['is_favorite' => $is_favorite]);
?>
