<?php
require_once '../includes/config.php';
require_once '../includes/Auth.php';

$auth = new Auth();

// Verificar se é admin
if (!$auth->isAdmin()) {
    header('Location: ../index.php');
    exit;
}

$current_user = $auth->getCurrentUser();
$all_users = $auth->getAllUsers();
$action = $_GET['action'] ?? '';
$user_id = $_GET['user_id'] ?? '';

// Processar ações
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $action = $_POST['action'] ?? '';
    $user_id = $_POST['user_id'] ?? '';

    if ($action === 'toggle_status') {
        $user = null;
        foreach ($all_users as $u) {
            if ($u['id'] === $user_id) {
                $user = $u;
                break;
            }
        }
        if ($user) {
            $auth->updateUserStatus($user_id, !$user['is_active']);
            header('Location: usuarios.php');
            exit;
        }
    } elseif ($action === 'promote_admin') {
        $auth->promoteToAdmin($user_id);
        header('Location: usuarios.php');
        exit;
    }
}
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Gerenciar Usuários - Superflix</title>
    <link rel="stylesheet" href="../assets/css/style.css">
</head>
<body class="authenticated">
    <header>
        <div class="container">
            <nav class="navbar">
                <a href="../index.php" class="logo">
                    <span style="color: #1db954;">●</span> SUPERFLIX ADMIN
                </a>
                
                <ul class="nav-links">
                    <li><a href="dashboard.php">Dashboard</a></li>
                    <li><a href="usuarios.php" class="active">Usuários</a></li>
                    <li><a href="mensagens.php">Mensagens</a></li>
                </ul>

                <div class="nav-right">
                    <a href="../logout.php" class="btn btn-danger btn-sm">Sair</a>
                </div>
            </nav>
        </div>
    </header>

    <section class="section">
        <div class="container">
            <h2 class="section-title">Gerenciar Usuários</h2>

            <div style="background-color: var(--bg-secondary); padding: 1.5rem; border-radius: 8px; border: 1px solid var(--border-color); overflow-x: auto;">
                <table>
                    <thead>
                        <tr>
                            <th>Nome</th>
                            <th>Email</th>
                            <th>WhatsApp</th>
                            <th>Função</th>
                            <th>Data de Cadastro</th>
                            <th>Status</th>
                            <th>Ações</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($all_users as $user): ?>
                            <tr>
                                <td><?php echo htmlspecialchars($user['name']); ?></td>
                                <td><?php echo htmlspecialchars($user['email']); ?></td>
                                <td><?php echo htmlspecialchars($user['whatsapp']); ?></td>
                                <td>
                                    <span style="padding: 0.25rem 0.75rem; border-radius: 15px; font-size: 0.9rem; background-color: <?php echo $user['role'] === 'admin' ? 'rgba(29, 185, 84, 0.2)' : 'rgba(100, 100, 100, 0.2)'; ?>; color: <?php echo $user['role'] === 'admin' ? 'var(--success)' : 'var(--text-secondary)'; ?>;">
                                        <?php echo ucfirst($user['role']); ?>
                                    </span>
                                </td>
                                <td><?php echo date('d/m/Y H:i', strtotime($user['created_at'])); ?></td>
                                <td>
                                    <span style="padding: 0.25rem 0.75rem; border-radius: 15px; font-size: 0.9rem; background-color: <?php echo $user['is_active'] ? 'rgba(29, 185, 84, 0.2)' : 'rgba(231, 76, 60, 0.2)'; ?>; color: <?php echo $user['is_active'] ? 'var(--success)' : 'var(--danger)'; ?>;">
                                        <?php echo $user['is_active'] ? 'Ativo' : 'Inativo'; ?>
                                    </span>
                                </td>
                                <td>
                                    <form method="POST" style="display: inline;">
                                        <input type="hidden" name="user_id" value="<?php echo $user['id']; ?>">
                                        <input type="hidden" name="action" value="toggle_status">
                                        <button type="submit" class="btn btn-sm" style="background-color: <?php echo $user['is_active'] ? 'var(--danger)' : 'var(--success)'; ?>; color: white; border: none; cursor: pointer;">
                                            <?php echo $user['is_active'] ? 'Desativar' : 'Ativar'; ?>
                                        </button>
                                    </form>
                                    
                                    <?php if ($user['role'] !== 'admin'): ?>
                                        <form method="POST" style="display: inline;">
                                            <input type="hidden" name="user_id" value="<?php echo $user['id']; ?>">
                                            <input type="hidden" name="action" value="promote_admin">
                                            <button type="submit" class="btn btn-sm btn-primary" style="margin-left: 0.5rem;">Promover</button>
                                        </form>
                                    <?php endif; ?>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>

            <div style="margin-top: 2rem;">
                <a href="dashboard.php" class="btn btn-secondary">Voltar ao Dashboard</a>
            </div>
        </div>
    </section>

    <footer style="background-color: var(--bg-secondary); border-top: 1px solid var(--border-color); padding: 2rem 0; margin-top: 3rem;">
        <div class="container">
            <p class="text-center" style="color: var(--text-secondary);">© 2025 Superflix Admin. Todos os direitos reservados.</p>
        </div>
    </footer>
</body>
</html>
