<?php
require_once '../includes/config.php';
require_once '../includes/Auth.php';

$auth = new Auth();

// Verificar se é admin
if (!$auth->isAdmin()) {
    header('Location: ../index.php');
    exit;
}

$current_user = $auth->getCurrentUser();
$all_users = $auth->getAllUsers();
$users_with_whatsapp = array_filter($all_users, function($u) { return !empty($u['whatsapp']); });
$active_users = array_filter($all_users, function($u) { return $u['is_active']; });
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Painel Admin - Superflix</title>
    <link rel="stylesheet" href="../assets/css/style.css">
</head>
<body class="authenticated">
    <header>
        <div class="container">
            <nav class="navbar">
                <a href="../index.php" class="logo">
                    <span style="color: #1db954;">●</span> SUPERFLIX ADMIN
                </a>
                
                <ul class="nav-links">
                    <li><a href="dashboard.php" class="active">Dashboard</a></li>
                    <li><a href="usuarios.php">Usuários</a></li>
                    <li><a href="mensagens.php">Mensagens</a></li>
                </ul>

                <div class="nav-right">
                    <a href="../logout.php" class="btn btn-danger btn-sm">Sair</a>
                </div>
            </nav>
        </div>
    </header>

    <section class="section">
        <div class="container">
            <h2 class="section-title">Dashboard Administrativo</h2>

            <div class="row" style="margin-bottom: 2rem;">
                <div class="col-3">
                    <div style="background-color: var(--bg-secondary); padding: 1.5rem; border-radius: 8px; border: 1px solid var(--border-color); text-align: center;">
                        <div style="font-size: 2rem; color: var(--primary); font-weight: 700; margin-bottom: 0.5rem;">
                            <?php echo count($all_users); ?>
                        </div>
                        <div style="color: var(--text-secondary);">Total de Usuários</div>
                    </div>
                </div>
                <div class="col-3">
                    <div style="background-color: var(--bg-secondary); padding: 1.5rem; border-radius: 8px; border: 1px solid var(--border-color); text-align: center;">
                        <div style="font-size: 2rem; color: var(--primary); font-weight: 700; margin-bottom: 0.5rem;">
                            <?php echo count($users_with_whatsapp); ?>
                        </div>
                        <div style="color: var(--text-secondary);">Com WhatsApp</div>
                    </div>
                </div>
                <div class="col-3">
                    <div style="background-color: var(--bg-secondary); padding: 1.5rem; border-radius: 8px; border: 1px solid var(--border-color); text-align: center;">
                        <div style="font-size: 2rem; color: var(--primary); font-weight: 700; margin-bottom: 0.5rem;">
                            <?php echo count($active_users); ?>
                        </div>
                        <div style="color: var(--text-secondary);">Usuários Ativos</div>
                    </div>
                </div>
                <div class="col-3">
                    <div style="background-color: var(--bg-secondary); padding: 1.5rem; border-radius: 8px; border: 1px solid var(--border-color); text-align: center;">
                        <div style="font-size: 2rem; color: var(--primary); font-weight: 700; margin-bottom: 0.5rem;">
                            <?php echo count($all_users) - count($active_users); ?>
                        </div>
                        <div style="color: var(--text-secondary);">Usuários Inativos</div>
                    </div>
                </div>
            </div>

            <div style="background-color: var(--bg-secondary); padding: 1.5rem; border-radius: 8px; border: 1px solid var(--border-color);">
                <h3 style="margin-bottom: 1rem;">Últimos Usuários Cadastrados</h3>
                
                <table>
                    <thead>
                        <tr>
                            <th>Nome</th>
                            <th>Email</th>
                            <th>WhatsApp</th>
                            <th>Data de Cadastro</th>
                            <th>Status</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php 
                        $recent_users = array_slice($all_users, 0, 10);
                        foreach ($recent_users as $user): 
                        ?>
                            <tr>
                                <td><?php echo htmlspecialchars($user['name']); ?></td>
                                <td><?php echo htmlspecialchars($user['email']); ?></td>
                                <td><?php echo htmlspecialchars($user['whatsapp']); ?></td>
                                <td><?php echo date('d/m/Y H:i', strtotime($user['created_at'])); ?></td>
                                <td>
                                    <span style="padding: 0.25rem 0.75rem; border-radius: 15px; font-size: 0.9rem; background-color: <?php echo $user['is_active'] ? 'rgba(29, 185, 84, 0.2)' : 'rgba(231, 76, 60, 0.2)'; ?>; color: <?php echo $user['is_active'] ? 'var(--success)' : 'var(--danger)'; ?>;">
                                        <?php echo $user['is_active'] ? 'Ativo' : 'Inativo'; ?>
                                    </span>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>

                <div style="margin-top: 1rem;">
                    <a href="usuarios.php" class="btn btn-primary">Ver Todos os Usuários</a>
                </div>
            </div>

            <div style="margin-top: 2rem; background-color: var(--bg-secondary); padding: 1.5rem; border-radius: 8px; border: 1px solid var(--border-color);">
                <h3 style="margin-bottom: 1rem;">Ações Rápidas</h3>
                <div class="row">
                    <div class="col-3">
                        <a href="usuarios.php" class="btn btn-secondary btn-block">Gerenciar Usuários</a>
                    </div>
                    <div class="col-3">
                        <a href="mensagens.php" class="btn btn-secondary btn-block">Enviar Mensagens</a>
                    </div>
                    <div class="col-3">
                        <a href="banners.php" class="btn btn-secondary btn-block">Gerenciar Banners</a>
                    </div>
                    <div class="col-3">
                        <a href="../index.php" class="btn btn-secondary btn-block">Voltar ao Site</a>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <footer style="background-color: var(--bg-secondary); border-top: 1px solid var(--border-color); padding: 2rem 0; margin-top: 3rem;">
        <div class="container">
            <p class="text-center" style="color: var(--text-secondary);">© 2025 Superflix Admin. Todos os direitos reservados.</p>
        </div>
    </footer>
</body>
</html>
