<?php
/**
 * Configuração Principal - Superflix Clone
 */

// Definições de ambiente
define('BASE_URL', 'http://localhost:8000/');
define('ROOT_PATH', dirname(dirname(__FILE__)));
define('DATA_PATH', ROOT_PATH . '/data');
define('USERS_PATH', DATA_PATH . '/users');
define('FAVORITES_PATH', DATA_PATH . '/favorites');
define('CACHE_PATH', DATA_PATH . '/cache');

// Configurações da API Superflix
define('SUPERFLIX_API_URL', 'https://sfl.centralapps.space/api');
define('SUPERFLIX_API_KEY', '9ae9713b2292d6e130bb9e4c44db58e6');

// Configurações de sessão
define('SESSION_TIMEOUT', 86400); // 24 horas
define('SESSION_NAME', 'superflix_session');

// Configurações de cache
define('CACHE_DURATION', 3600); // 1 hora

// Configuração de WhatsApp
define('WHATSAPP_API_URL', 'https://api.whatsapp.com/send');

// Criar diretórios se não existirem
if (!is_dir(USERS_PATH)) mkdir(USERS_PATH, 0755, true);
if (!is_dir(FAVORITES_PATH)) mkdir(FAVORITES_PATH, 0755, true);
if (!is_dir(CACHE_PATH)) mkdir(CACHE_PATH, 0755, true);

// Iniciar sessão
session_name(SESSION_NAME);
session_start();

// Definir timezone
date_default_timezone_set('America/Sao_Paulo');

// Tratamento de erros
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Headers de segurança
header('X-Content-Type-Options: nosniff');
header('X-Frame-Options: SAMEORIGIN');
header('X-XSS-Protection: 1; mode=block');
