# Superflix Clone - Plataforma de Streaming

Uma plataforma completa de streaming de filmes, séries e animes desenvolvida em **PHP puro** com autenticação por arquivo JSON, sem dependência de banco de dados.

## 🎯 Características

- ✅ **Autenticação de Usuários** - Cadastro com e-mail e WhatsApp obrigatórios
- ✅ **Integração com API Superflix** - Acesso a catálogo completo de conteúdo
- ✅ **Reprodutor de Vídeo** - Embed compatível com múltiplos servidores
- ✅ **Sistema de Favoritos** - Salve seus conteúdos preferidos
- ✅ **Painel Administrativo** - Gerenciamento completo de usuários
- ✅ **Mensagens via WhatsApp** - Comunique-se com usuários sobre novidades
- ✅ **Design Responsivo** - Funciona em todos os dispositivos
- ✅ **Tema Escuro** - Interface moderna com destaque verde

## 📋 Requisitos

- PHP 7.4 ou superior
- Servidor Apache com mod_rewrite ativado
- Extensão cURL habilitada
- Permissões de escrita na pasta `/data`

## 🚀 Instalação

### 1. Fazer Upload dos Arquivos

Faça upload de todos os arquivos para sua hospedagem:

```bash
superflix-clone/
├── public/              # Raiz do site (aponte seu domínio aqui)
├── includes/            # Arquivos de configuração e classes
├── data/                # Dados de usuários e favoritos
├── assets/              # CSS e JavaScript
└── .htaccess            # Configurações Apache
```

### 2. Configurar Permissões

Certifique-se que a pasta `data` tem permissões de escrita:

```bash
chmod -R 755 data/
chmod -R 755 data/users/
chmod -R 755 data/favorites/
chmod -R 755 data/cache/
```

### 3. Configurar o Domínio

Aponte seu domínio para a pasta `public/`:

```
www.seudominio.com → /public/
```

### 4. Testar a Instalação

Acesse `https://www.seudominio.com` e você deverá ver a página inicial.

## 🔧 Configuração

### Editar Configurações

Abra o arquivo `includes/config.php` para ajustar:

- `BASE_URL` - URL da sua plataforma
- `SUPERFLIX_API_KEY` - Chave da API Superflix (já configurada)
- `SESSION_TIMEOUT` - Tempo de sessão (padrão: 24 horas)
- `CACHE_DURATION` - Duração do cache de conteúdo (padrão: 1 hora)

### Criar Primeiro Admin

Para criar o primeiro usuário administrador:

1. Registre-se normalmente no site
2. Acesse via FTP o arquivo `data/users/users.json`
3. Altere o campo `"role"` para `"admin"` do seu usuário
4. Salve o arquivo

## 📁 Estrutura de Arquivos

```
superflix-clone/
│
├── public/                      # Raiz pública do site
│   ├── index.php               # Página inicial
│   ├── login.php               # Página de login
│   ├── registro.php            # Página de registro
│   ├── catalogo.php            # Catálogo de conteúdo
│   ├── detalhes.php            # Página de detalhes
│   ├── minha-lista.php         # Favoritos do usuário
│   ├── perfil.php              # Perfil do usuário
│   ├── logout.php              # Logout
│   ├── api/
│   │   └── favorites/          # APIs de favoritos
│   └── admin/                  # Painel administrativo
│       ├── dashboard.php       # Dashboard
│       ├── usuarios.php        # Gerenciar usuários
│       └── mensagens.php       # Enviar mensagens
│
├── includes/                   # Arquivos de backend
│   ├── config.php             # Configurações principais
│   ├── Auth.php               # Classe de autenticação
│   ├── SuperflixAPI.php       # Integração com API
│   └── Favorites.php          # Gerenciamento de favoritos
│
├── data/                       # Dados persistentes
│   ├── users/                 # Arquivos JSON de usuários
│   ├── favorites/             # Arquivos JSON de favoritos
│   └── cache/                 # Cache de conteúdo
│
├── assets/                     # Recursos estáticos
│   ├── css/
│   │   └── style.css          # Estilos principais
│   └── js/
│       └── app.js             # JavaScript principal
│
└── .htaccess                   # Configurações Apache
```

## 👤 Autenticação

### Registro

- Email válido obrigatório
- WhatsApp com mínimo 10 dígitos
- Senha com mínimo 6 caracteres

### Login

- Email e senha
- Sessão com timeout de 24 horas
- Armazenamento em arquivo JSON

## 🎬 Uso da API Superflix

A plataforma integra automaticamente com a API Superflix:

- **Filmes**: Listagem, busca, filtros por gênero
- **Séries**: Listagem, navegação de temporadas e episódios
- **Embed**: Reprodutor compatível com múltiplos servidores
- **Cache**: Dados em cache por 1 hora para melhor performance

## 💬 Sistema de Mensagens WhatsApp

### Para Administradores

1. Acesse o Painel Admin → Mensagens
2. Compose sua mensagem
3. Selecione destinatários (todos ou específicos)
4. Clique nos links para enviar via WhatsApp

### Dados Necessários

Os usuários devem ter WhatsApp válido cadastrado para receber mensagens.

## 🎨 Personalização

### Cores

Edite as variáveis CSS em `assets/css/style.css`:

```css
:root {
    --primary: #1db954;           /* Verde principal */
    --bg-dark: #0f0f0f;           /* Fundo escuro */
    --text-primary: #ffffff;      /* Texto principal */
}
```

### Logotipo

Altere o texto "SUPERFLIX" no header das páginas.

## 🔒 Segurança

- Senhas com hash BCRYPT
- Proteção contra XSS
- Headers de segurança HTTP
- Validação de entrada
- Sessões seguras

## 📱 Responsividade

O site é totalmente responsivo:

- **Desktop**: Layout completo
- **Tablet**: Adaptado para telas médias
- **Mobile**: Otimizado para smartphones

## 🐛 Troubleshooting

### "Erro ao conectar à API"

- Verifique se cURL está habilitado
- Confirme a chave da API em `config.php`
- Teste a conexão com: `curl https://sfl.centralapps.space/api/movies/list`

### "Erro de permissão na pasta data"

```bash
chmod -R 777 data/
```

### "Sessão não funciona"

- Verifique se cookies estão habilitados
- Confirme `session.save_path` no php.ini

### "Reprodutor não funciona"

- Confirme que JavaScript está habilitado
- Verifique o console do navegador para erros
- Teste em outro navegador

## 📞 Suporte

Para problemas com a API Superflix, visite: https://sfl.centralapps.space/api

## 📄 Licença

Desenvolvido para uso pessoal e comercial.

## 🎓 Versão

**Superflix Clone v1.0** - Dezembro 2025

---

**Desenvolvido com ❤️ para streaming de qualidade**
